/*

-- Macro Scripts File
-- Macro Scripts for render properties and render presets

Revision History:

	30 Juin 2004, Pierre-Felix Breton
		bug fix:  motion blur don't fail anymore on multiple selection

	4 May 2004, Pierre-Felix Breton
		modified the quick render presets shortcuts to skip the environement and effects categories
		added icons

	29 march 2004, Pierre-Felix Breton
		added "quick render shortcuts" macros, for render presets
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

 	9 Juin 2003: Pierre-Felix Breton
 	added tests for "bylayer/byobject" flags to prevent "disconnections" from the layer system.
	
*/


--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

--------------------------------------------------------------------------------------------
-- Quick render shortcuts macros 
--------------------------------------------------------------------------------------------

/*
Usage:

	Once on a toolbar, a user can Shift + Click, it will save the current render settings in a "slot"
	Click on the button loads the settings.
*/

macroScript RenderPresetSlotA
	category:~RENDERPRESETSLOTA_CATEGORY~
	internalCategory: "Render" 
	toolTip:~RENDERPRESETSLOTA_TOOLTIP~ 
	ButtonText:"A"
	iconName:"RenderShotcuts/A"

(

	on execute do
	(
		if (keyboard.shiftPressed) 
		then RenderPresets.Save 0 ((getdir #renderpresets) + "\\a.rps") #{1,4..64} --shift key saves the preset. Environment and Effects categories (2 and 3) are skipped on purpose
		else -- no key pressed
		(
			--load the preset
			if (doesFileExist ((getdir #renderpresets) + "\\a.rps") == true) do	renderpresets.LoadAll 0 ((getdir #renderpresets) + "\\a.rps")
		)
	)--end on execute
)


macroScript RenderPresetSlotB
	category:~RENDERPRESETSLOTB_CATEGORY~
	internalCategory: "Render" 
	toolTip:~RENDERPRESETSLOTB_TOOLTIP~ 
	ButtonText:"B"
	iconName:"RenderShotcuts/B"

(

	on execute do
	(
		if (keyboard.shiftPressed) 
		then RenderPresets.Save 0 ((getdir #renderpresets) + "\\b.rps") #{1,4..64} --shift key saves the preset. Environment and Effects categories (2 and 3) are skipped on purpose
		else -- no key pressed
		(
			--load the preset
			if (doesFileExist ((getdir #renderpresets) + "\\b.rps") == true) do	renderpresets.LoadAll 0 ((getdir #renderpresets) + "\\b.rps")
		)
	)--end on execute
)



macroScript RenderPresetSlotC
	category:~RENDERPRESETSLOTC_CATEGORY~
	internalCategory: "Render" 
	toolTip:~RENDERPRESETSLOTC_TOOLTIP~ 
	ButtonText:"C"
	iconName:"RenderShotcuts/C"
(

	on execute do
	(
		if (keyboard.shiftPressed) 
		then RenderPresets.Save 0 ((getdir #renderpresets) + "\\c.rps") #{1,4..64} --shift key saves the preset. Environment and Effects categories (2 and 3) are skipped on purpose
		else -- no key pressed
		(
			--load the preset
			if (doesFileExist ((getdir #renderpresets) + "\\c.rps") == true) do	renderpresets.LoadAll 0 ((getdir #renderpresets) + "\\c.rps")
		)
	)--end on execute
		

)



--------------------------------------------------------------------------------------------
-- Object properties macros 
--------------------------------------------------------------------------------------------
MacroScript InheritVis
            ButtonText:~INHERITVIS_BUTTONTEXT~
            category:~INHERITVIS_CATEGORY~
            internalCategory:"Render"
            Tooltip:~INHERITVIS_TOOLTIP~ 
(

	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_InheritVisibility #Cond_Enabled
	)
	on IsIndeterminate do
	(			
		return  nodeSelectionSet.GetRenderPropState #RenderProp_InheritVisibility #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_InheritVisibility #Cond_AnyChecked
	)
	On Execute Do  
	(
		iret =  nodeSelectionSet.GetRenderPropState #RenderProp_InheritVisibility #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_InheritVisibility iret		
	)
)

MacroScript Renderable
            ButtonText:~RENDERABLE_BUTTONTEXT~
            category:~RENDERABLE_CATEGORY~
            internalCategory:"Render"
            Tooltip:~RENDERABLE_TOOLTIP~ 
(

	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_Renderable #Cond_Enabled
	)
	on IsIndeterminate do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_Renderable #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_Renderable #Cond_AnyChecked
	)
	On Execute Do  
	(		
		iret =  nodeSelectionSet.GetRenderPropState #RenderProp_Renderable #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_Renderable iret		
	)
)

MacroScript CastShadows
            ButtonText:~CASTSHADOWS_BUTTONTEXT~
            category:~CASTSHADOWS_CATEGORY~
            internalCategory:"Render"
            Tooltip:~CASTSHADOWS_TOOLTIP~ 
(
	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_CastShadows #Cond_Enabled
	)
	on IsIndeterminate do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_CastShadows #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_CastShadows #Cond_AnyChecked
	)
	On Execute Do  
	(		
		iret =  nodeSelectionSet.GetRenderPropState #RenderProp_CastShadows #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_CastShadows iret		
	)
)
MacroScript ReceiveShadows
            ButtonText:~RECEIVESHADOWS_BUTTONTEXT~
            category:~RECEIVESHADOWS_CATEGORY~
            internalCategory:"Render"
            Tooltip:~RECEIVESHADOWS_TOOLTIP~ 
(
	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_ReceiveShadows #Cond_Enabled
	)
	on IsIndeterminate do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_ReceiveShadows #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_ReceiveShadows #Cond_AnyChecked
	)
	On Execute Do  
	(		
		iret =  nodeSelectionSet.GetRenderPropState #RenderProp_ReceiveShadows #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_ReceiveShadows iret		
	)

)

MacroScript VisibleToCamera
            ButtonText:~VISIBLETOCAMERA_BUTTONTEXT~
            category:~VISIBLETOCAMERA_CATEGORY~
            internalCategory:"Render"
            Tooltip:~VISIBLETOCAMERA_TOOLTIP~ 
(
	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_InvisibleToCamera #Cond_Enabled
	)
	on IsIndeterminate do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_InvisibleToCamera #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return not nodeSelectionSet.GetRenderPropState #RenderProp_InvisibleToCamera #Cond_AnyChecked
	)
	On Execute Do  
	(		
		iret =  not nodeSelectionSet.GetRenderPropState #RenderProp_InvisibleToCamera #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_InvisibleToCamera iret		
	)

)

MacroScript VisibleToReflection
            ButtonText:~VISIBLETOREFLECTION_BUTTONTEXT~
            category:~VISIBLETOREFLECTION_CATEGORY~
            internalCategory:"Render"
            Tooltip:~VISIBLETOREFLECTION_TOOLTIP~ 
(
	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_InvisibleToReflections #Cond_Enabled
	)
	on IsIndeterminate do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_InvisibleToReflections #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return not nodeSelectionSet.GetRenderPropState #RenderProp_InvisibleToReflections #Cond_AnyChecked
	)
	On Execute Do  
	(		
		iret =  not nodeSelectionSet.GetRenderPropState #RenderProp_InvisibleToReflections #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_InvisibleToReflections iret		
	)
)

MacroScript ApplyAtmospherics
            ButtonText:~APPLYATMOSPHERICS_BUTTONTEXT~
            category:~APPLYATMOSPHERICS_CATEGORY~
            internalCategory:"Render"
            Tooltip:~APPLYATMOSPHERICS_TOOLTIP~ 
(
	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_ApplyAtmospherics #Cond_Enabled
	)
	on IsIndeterminate do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_ApplyAtmospherics #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_ApplyAtmospherics #Cond_AnyChecked
	)
	On Execute Do  
	(		
		iret =  nodeSelectionSet.GetRenderPropState #RenderProp_ApplyAtmospherics #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_ iret		
	)
)
MacroScript RenderOccluded
            ButtonText:~RENDEROCCLUDED_BUTTONTEXT~
            category:~RENDEROCCLUDED_CATEGORY~
            internalCategory:"Render"
            Tooltip:~RENDEROCCLUDED_TOOLTIP~ 
(
	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_RenderOccluded #Cond_Enabled
	)
	on IsIndeterminate do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_RenderOccluded #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_RenderOccluded #Cond_AnyChecked
	)
	On Execute Do  
	(		
		iret =  nodeSelectionSet.GetRenderPropState #RenderProp_RenderOccluded #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_RenderOccluded iret		
	)
)
MacroScript MotionBlurToggle
            ButtonText:~MOTIONBLURTOGGLE_BUTTONTEXT~
            category:~MOTIONBLURTOGGLE_CATEGORY~
            internalCategory:"Render"
            Tooltip:~MOTIONBLURTOGGLE_TOOLTIP~ 
(
	On IsVisible do
	(
		Return  (selection.count > 0)		
	)
	On IsEnabled do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_MotionBlur #Cond_Enabled
	)
	on IsIndeterminate do
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_MotionBlur #Cond_Indeterminate
	)
	on ischecked Do  
	(
		return nodeSelectionSet.GetRenderPropState #RenderProp_MotionBlur #Cond_AnyChecked
	)
	On Execute Do  
	(		
		iret =  nodeSelectionSet.GetRenderPropState #RenderProp_MotionBlur #Cond_AnyUnchecked
		nodeSelectionSet.SetRenderPropState #RenderProp_MotionBlur iret		
	))
MacroScript RenderSelected
            ButtonText:~RENDERSELECTED_BUTTONTEXT~
            category:~RENDERSELECTED_CATEGORY~
            internalCategory:"Render"
            Tooltip:~RENDERSELECTED_TOOLTIP~ 
(
	On Execute Do Try (render rendertype:#selection)Catch ()
)



--------------------------------------------------------------------------------------------------
-- Ray tracer globals (scaline renderer) action items
--------------------------------------------------------------------------------------------------
-- Raytrace Globals Include Exclude

MacroScript ScanlineRenderer_RaytraceGlobals_IncludeExclude
ButtonText:~SCANLINERENDERER_RAYTRACEGLOBALS_INCLUDEEXCLUDE_BUTTONTEXT~
category:~SCANLINERENDERER_RAYTRACEGLOBALS_INCLUDEEXCLUDE_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~SCANLINERENDERER_RAYTRACEGLOBALS_INCLUDEEXCLUDE_TOOLTIP~ 

(
	on execute do
	(
			actionMan.executeAction 1195574963 "103"  -- Render: Global Raytracing exclude list
		)

	on isenabled return ((classof renderers.current == Default_Scanline_Renderer))
	on isvisible return ((classof renderers.current == Default_Scanline_Renderer))
)


--------------------------------------------------------------------------------------------------
-- Raytrace Globals

MacroScript ScanlineRenderer_RaytraceGlobals
ButtonText:~SCANLINERENDERER_RAYTRACEGLOBALS_BUTTONTEXT~
category:~SCANLINERENDERER_RAYTRACEGLOBALS_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~SCANLINERENDERER_RAYTRACEGLOBALS_TOOLTIP~ 

(
	on execute do
	(
			actionMan.executeAction 1195574963 "102"  -- Render: Global Raytracing Parameters
		)

	on isenabled return ((classof renderers.current == Default_Scanline_Renderer))
	on isvisible return ((classof renderers.current == Default_Scanline_Renderer))
)


--------------------------------------------------------------------------------------------
-- Gamma/Color Correction macros 
--------------------------------------------------------------------------------------------
MacroScript GammaSetup
ButtonText:~GAMMASETUP_BUTTONTEXT~
category:~GAMMASETUP_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~GAMMASETUP_TOOLTIP~ 

(
	on execute do
	(
		max file preferences gamma  -- Preferences Dialog, Gamma Tab
	)
)

MacroScript RenderA360Setup
ButtonText:~RENDERA360SETUP_BUTTONTEXT~
category:~RENDERA360SETUP_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~RENDERA360SETUP_TOOLTIP~ 
iconName:"MainUI/RenderInA360"

(
	on execute do
	(
	    isARTCloudInstalled = false
		for i = 1 to actionMan.numActionTables do (
			actionTable = actionMan.getActionTable i
			if  actionTable.id == 797320403 do (
				isARTCloudInstalled = true
			)
		)
		if isARTCloudInstalled then (
			actionMan.executeAction 797320403 "111"
		)
		else (
			rendUseNet = false --enforce the net render flag to off when executed. 
			maxOps.rendUseIterative = false
			renderSceneDialog.open()	
			renderers.renderDialogMode = #production
			renderers.target = "cloud"	
			macros.run "Render" "RenderButtonMenu_Switch_To_Cloud_Mode"
		)
	)
)

MacroScript RenderA360Gallery
ButtonText:~RENDERA360GALLERY_BUTTONTEXT~
category:~RENDERA360GALLERY_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~RENDERA360GALLERY_TOOLTIP~ 
iconName:"MainUI/OpenA360Gallery"

(
	on execute do
	(
		shellLaunch "https://rendering.360.autodesk.com/mygallery.aspx" ""	
	)
)